DAC0_DAT0L		EQU		0x4003F000	; DAC Data Low Register
DAC0_DAT0H		EQU		0x4003F001	; DAC Data High Register
DAC0_DAT1L		EQU		0x4003F002	; DAC Data Low Register
DAC0_DAT1H		EQU		0x4003F003	; DAC Data High Register
DAC0_SR				EQU		0x4003F020	; DAC Status Register
DAC0_C0				EQU		0x4003F021	; DAC Control Register
DAC0_C1				EQU		0x4003F022	; DAC Control Register 1
DAC0_C2				EQU		0x4003F023	; DAC Control Register 2

LPTMR0_CSR		EQU		0x40040000	; Low Power Timer Control Status Register
LPTMR0_PSR		EQU		0x40040004	; Low Power Timer Prescale Register
LPTMR0_CMR		EQU		0x40040008	; Low Power Timer Compare Register
LPTMR0_CNR		EQU		0x4004000C	; Low Power Timer Counter Register

SIM_SCGC4			EQU		0x40048034	; System Clock Gating Control Register 4
SIM_SCGC5			EQU		0x40048038	; System Clock Gating Control Register 5
SIM_SCGC6			EQU		0x4004803C	; System Clock Gating Control Register 6
SIM_CLKDIV1		EQU		0x40048044	; System Clock Divider Register 1
SIM_COPC			EQU		0x40048100	; COP Control Register

PORTA_PCR0		EQU		0x40049000

PORTA_GPCLR		EQU		0x40049080	; Global Pin Control Low Register
PORTA_GPCHR		EQU		0x40049084	; Global Pin Control High Register
PORTB_GPCLR		EQU		0x4004A080	; Global Pin Control Low Register
PORTB_GPCHR		EQU		0x4004A084	; Global Pin Control High Register

MCG_C1				EQU		0x40064000	; MCG Control 1 Register
MCG_C2				EQU		0x40064001	; MCG Control 2 Register
MCG_C3				EQU		0x40064002	; MCG Control 3 Register
MCG_C4				EQU		0x40064003	; MCG Control 4 Register
MCG_C6				EQU		0x40064005	; MCG Control 6 Register
MCG_S					EQU		0x40064006	; MCG Status Register
MCG_SC				EQU		0x40064008	; MCG Status and Control Register

I2C0_A1				EQU		0x40066000	; I2C Address Register 1
I2C0_F				EQU		0x40066001	; I2C Frequency Divider register
I2C0_C1				EQU		0x40066002	; I2C Control Register 1
I2C0_S				EQU		0x40066003	; I2C Status register
I2C0_D				EQU		0x40066004	; I2C Data I/O register
I2C0_C2				EQU		0x40066005	; I2C Control Register 2
I2C0_FLT			EQU		0x40066006	; I2C Programmable Input Glitch Filter register
I2C0_RA				EQU		0x40066007	; I2C Range Address register
I2C0_SMB			EQU		0x40066008	; I2C SMBus Control and Status register
I2C0_A2				EQU		0x40066009	; I2C Address Register 2
I2C0_SLTH			EQU		0x4006600A	; I2C SCL Low Timeout Register High
I2C0_SLTL			EQU		0x4006600B	; I2C SCL Low Timeout Register Low 

LLWU_ME				EQU		0x4007C002	; LLWU Module Enable register 

SMC_PMPROT		EQU		0x4007E000	; Power Mode Protection register
SMC_PMCTRL		EQU		0x4007E001	; Power Mode Control register
SMC_STOPCTRL	EQU		0x4007E002	; Stop Control Register
SMC_PMSTAT		EQU		0x4007E003	; Power Mode Status register

GPIOA_PDOR		EQU		0x400FF000	; Port Data Output Register
GPIOA_PSOR		EQU		0x400FF004	; Port Set Output Register
GPIOA_PCOR		EQU		0x400FF008	; Port Clear Output Register
GPIOA_PTOR		EQU		0x400FF00C	; Port Toggle Output Register
GPIOA_PDIR		EQU		0x400FF010	; Port Data Input Register
GPIOA_PDDR		EQU		0x400FF014	; Port Data Direction Register
GPIOB_PDOR		EQU		0x400FF040	; Port Data Output Register
GPIOB_PSOR		EQU		0x400FF044	; Port Set Output Register
GPIOB_PCOR		EQU		0x400FF048	; Port Clear Output Register
GPIOB_PTOR		EQU		0x400FF04C	; Port Toggle Output Register
GPIOB_PDIR		EQU		0x400FF050	; Port Data Input Register
GPIOB_PDDR		EQU		0x400FF054	; Port Data Direction Register

NVIC_ISER			EQU		0xE000E100	; NVIC SETENA
NVIC_ICER			EQU		0xE000E180	; NVIC CLRENA
NVIC_ISPR			EQU		0xE000E200	; NVIC SETPEND
NVIC_ICPR			EQU		0xE000E280	; NVIC CLRPEND

SCB_SCR				EQU		0xE000ED10	; System Control Register

	MACRO													; store word at given adress
	SETW		$addr, $wdata
	ldr			R0, =$addr
	ldr			R1, =$wdata
	str			R1, [R0]
	MEND

	MACRO													; store halfword at given address
	SETH		$addr, $wdata
	ldr			R0, =$addr
	ldr			R1, =$wdata
	strh		R1, [R0]
	MEND

	MACRO													; store byte at given address
	SETB		$addr, $wdata
	ldr			R0, =$addr
	movs		R1, #$wdata
	strb		R1, [R0]
	MEND

;	MACRO													; store byte at given address
;	GETB		$addr, $wdata
;	ldr			R0, =$addr
;	ldrb		R1, [R0]
;	MEND
	
	MACRO													; AND a word with data in memory
	IOANDW	$addr, $wdata
	ldr			R0, =($addr + (1<<26))
	ldr			R1, =$wdata
	str			R1, [R0]
	MEND

	MACRO													; AND a halfword with data in memory
	IOANDH	$addr, $wdata
	ldr			R0, =($addr + (1<<26))
	ldr			R1, =$wdata
	strh		R1, [R0]
	MEND

	MACRO													; AND a byte with data in memory
	IOANDB	$addr, $wdata
	ldr			R0, =($addr + (1<<26))
	movs		R1, #$wdata
	strb		R1, [R0]
	MEND
	
	MACRO													; OR a word with data in memory
	IOORW		$addr, $wdata
	ldr			R0, =($addr + (1<<27))
	ldr			R1, =$wdata
	str			R1, [R0]
	MEND

	MACRO													; OR a halfword with data in memory
	IOORH		$addr, $wdata
	ldr			R0, =($addr + (1<<27))
	ldr			R1, =$wdata
	strh		R1, [R0]
	MEND

	MACRO													; OR a byte with data in memory
	IOORB		$addr, $wdata
	ldr			R0, =($addr + (1<<27))
	movs		R1, #$wdata
	strb		R1, [R0]
	MEND	
	
	MACRO													; XOR a word with data in memory
	IOXORW	$addr, $wdata
	ldr			R0, =($addr + (3<<26))
	ldr			R1, =$wdata
	str			R1, [R0]
	MEND

	MACRO													; XOR a halfword with data in memory
	IOXORH	$addr, $wdata
	ldr			R0, =($addr + (3<<26))
	ldr			R1, =$wdata
	strh		R1, [R0]
	MEND

	MACRO													; XOR a byte with data in memory
	IOXORB	$addr, $wdata
	ldr			R0, =($addr + (3<<26))
	movs		R1, #$wdata
	strb		R1, [R0]
	MEND		
	
	MACRO													; function call
	CALL		$func
	ldr			R0, =$func
	blx			R0
	MEND
	
	END
	