#include <mega16.h> 
#include <delay.h>

unsigned char cnt_bit = 0;              //  
unsigned char code [14];                // 

unsigned char counter = 0;              //"" 

#define l_min    40                     //  "" (long)   ,  "" , 1,28..2,176 
#define l_max    68
#define s_min    22                     //  "" (short)   ,  "" , 0,704..1,088
#define s_max    34

bit state =  0;                                 //   
bit error = 0;                                  // 

//  ,  14 
unsigned char startbit1 = 0;                    //  , .. = 1
unsigned char startbit2 = 0;                    //  , .. = 1                    
unsigned char toggle = 0;                       // ,      ,   -  .!
unsigned char address = 0;                      // , 5 
unsigned char command = 0;                      // (), 6 

// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
        {
        counter = TCNT0;                        //  -
        TCNT0 = 0x00;                           // 
        error = 1;                              //  -    ,   
               
        if (cnt_bit == 0)                       //    
                {
                TCCR0 = 0x04;                           // ,  31250 (      )
                code [cnt_bit] = !PIND.2;               //  , PIND.2 -  ,  0
                cnt_bit++;                              //   
                state = 1;                              // , ..  1
                }
                  
                else                                        //   (   )
                        {
                        if ((counter>s_min) && (counter<s_max)) //  
                                {
                                if (state)                      //  1
                                        {
                                        state = 0;              // 
                                        error = 0;              // , ..  
                                        }
                                        else                    //  0
                                                {
                                                state = 1;                      // , ..  - 1
                                                code[cnt_bit] = !PIND.2;        //  -  
                                                cnt_bit++;                      //  
                                                error=0;                        // , ..  
                                                };
                                };     
                   
                        if ((counter>l_min) && (counter<l_max)) //  
                                {
                                code[cnt_bit] = !PIND.2;        //  -  
                                cnt_bit++;                      //  
                                error = 0;                      // , ..  
                                };
                                                  
                        if (error == 1)                         //       ,  
                                {
                                char i = 0;                     // 
                                
                                TCCR0 = 0x00;                   // 
                                TCNT0 = 0x00;                   // 
                                counter = 0;                    // 
                                cnt_bit = 0;                    //   
                                for (i=0; i<14; i++) code[i]=0; //   
                                };
                   
                        if (cnt_bit == 14)                      //   14 
                                {
                                char i = 0;                     // 
                                TCCR0 = 0x00;                   // 
                                TCNT0 = 0x00;;                  // 
                                cnt_bit = 0;                    //   
                                
                                startbit1 = code[0];            //  
                                startbit2 = code[1];            //  
                                toggle = code[2];               //-
                                                                //    
                                address = (code[3] << 4)|(code[4] << 3)|(code[5] << 2)|(code[6] << 1)|code[7];                    
                                command = (code[8] << 5)|(code[9] << 4)|(code[10] << 3 )|(code[11] << 2)|(code[12] << 1)|code[13];
                                     
                                for (i=0; i<14; i++) code[i]=0; //   
                                };
                        };                                                                                
        }

// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
        {
        char i = 0;                     // 
        
        TCCR0 = 0x00;                   // 
        TCNT0 = 0x00;                   // 
        counter = 0;                    // 
        cnt_bit = 0;                    //   
        for (i=0; i<14; i++) code[i]=0; //   
        }