/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */

//
// VS1001 registers
//
#define VS1001_MODE	0x00
#define VS1001_STATUS	0x01
#define VS1001_INTFCTLH	0x02
#define VS1001_CLOCKF	0x03
#define VS1001_PLAYTIME	0x04
#define VS1001_AUDATA	0x05
#define VS1001_VOLUME	0x0B


//
// setup I/O pins and directions for
// communicating with the VS1001
//
void vs1001_init_io(void);

//
// reset the VS1001
//
void vs1001_reset(void);

//
// set the VS1001 volume
//
void vs1001_setvolume(u08 left, u08 right);

//
// send a number of zero's to the VS1001
//
void vs1001_nulls(u16 nNulls);

//
// send a 16 bit value to a VS1001 register
//
void vs1001_write(u08 address, u16 data);

//
// read a 16 bit value from a VS1001 register
//
u16 vs1001_read(u08 address);

//
// send MP3 data
//
void vs1001_send_data(u08 b);

//
// send MP3 data in 32 byte blocks
//
void vs1001_send_32(u08 *p);

//
// Set the crystal compensation value
//
void vs1001_setcomp(u16 comp);
