/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */

#ifndef __UART_H__
#define __UART_H__

#include "types.h"
#include "Constants.h"


/* UART Baud rate calculation */
#define UART_CPU			F_CPU
#define UART_BAUD_RATE			115200
#define UART_BAUD_SELECT		(UART_CPU / (UART_BAUD_RATE * 16L) - 1)

#if defined (__AVR_ATmega162__)
 #define RXCIE	RXCIE0
 #define RXEN	RXEN0
 #define TXEN	TXEN0 
 #define UBRR0	UBRR0L
 #define UBRRH	UBRR0H
 #define UDRE	UDRE0
#endif

/* Global functions */
#ifdef ENABLE_SERIAL
extern volatile bool UART_CharReceived;

void UART_Init(void);
#define UART_HasChar() UART_CharReceived
u08  UART_ReceiveByte(void);
bool UART_CheckRxBuf(void);
extern void UART_SendByte(u08 Data);
extern void UART_Puts(u08* pBuf);
extern void UART_Puts_p(char const *p);
extern void UART_Putsln(u08* pBuf);
extern void UART_PrintfEndOfLine(void);
extern void UART_Printfu08(u08 Data);
extern void UART_Printfu16(u16 Data);
extern void UART_Printfu32(u32 Data);

#define PRINT(string)	UART_Puts(string)
#define PRINT_p(addr)	UART_Puts_p(addr)
#define EOL()		UART_PrintfEndOfLine()

#else // !ENABLE_SERIAL

#define UART_Init()
#define UART_HasChar() false
#define UART_SendByte(Data)
#define UART_ReceiveByte() 0
#define UART_Puts(pBuf)
#define UART_Puts_p(p)
#define UART_Putsln(pBuf)
#define UART_PrintfEndOfLine()
#define UART_Printfu08()
#define UART_Printfu16(Data)
#define UART_Printfu32(Data)

#define PRINT(string)	
#define PRINT_p(addr)	
#define EOL()

#endif // ifdef ENABLE_SERIAL

#endif

