/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */

#ifndef __TYPES_H__
#define __TYPES_H__

#include <ctype.h>

#define MAX_U16  65535
#define MAX_S16  32767

typedef unsigned char	BYTE;
typedef unsigned int	WORD;
typedef unsigned long	DWORD;

// alternative types
typedef unsigned char  u08;
typedef unsigned int   u16;
typedef unsigned long  u32;

typedef char  s08;
typedef int   s16;
typedef long  s32;

typedef u08 bool;
#define true 1
#define false 0

#ifndef NULL
#define NULL	0
#endif


// Make an unsigned copy of div function
typedef struct {
	unsigned quot;
	unsigned rem;
} udiv_t;
extern udiv_t udiv(unsigned, unsigned) __asm__("__udivmodhi4") __ATTR_CONST__;

// This structures are used to simplify code, compiler doesn't optimize 
// well shifts
struct u16bytes
{
	u08 low, high;
};

union u16convert
{
	u16 value;
	struct u16bytes bytes;
};

struct u32bytes
{
	u08 byte1, byte2, byte3, byte4;
};

struct u32words
{
	u16 low, high;
};

union u32convert 
{
	u32 value;
	struct u32bytes bytes;
	struct u32words words;
};

typedef struct charspair	// auxilliary structure for making
{				//  of pairs national and normal characters
	u16 natJol;		// joliet national character code
	u08 norm;		// normal code
} charspair;


#endif
