/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */

#ifndef __MEM_H__
#define __MEM_H__

#include "types.h"
#include "Constants.h"

// 32 k External RAM

#define EXTRAM_START		0x460
#define EXTRAM_END		0x7FFF	

// 3 bytes _before_ LONG_NAME are also used!!!

#define SENSE_BUF		((u08*)(0x0470))		// length max 128
#define LONG_NAME		((u08*)(0x0500))		// length 256
#define DIR_NAME		((u08*)(0x0600))		// length 128
#define CD_NAME			((u08*)(0x0680))		// length 128
#define DIRS_TABLE		0x0700				// length max 256 dirs * 6B = 0x0600
#define RANDOM_TAB		((u08*)(0x0D00))		// length max 512 bytes = 4096 songs
#define DIR_CACHE		((u08*)0x1000)  		// length 0x4000

// free 0x5020 - 0x5fff

// This is the size of each buffer

#define BUFFER_SIZE		4096				// Don't change size in this version !!!
#define BUFFER1			0x6000
#define BUFFER2			(BUFFER1 + BUFFER_SIZE)
#define BUFFER1P		((u08*)BUFFER1)
#define BUFFER2P		((u08*)BUFFER2)

// eeprom positions
#define EEPROM_SONG_NUMBER	0x0001  /* u16 */
#define EEPROM_MAX_SONGS	0x0003  /* u16 */
#define EEPROM_VOLUME		0x0005	/* u08 */
#define EEPROM_RANDOM		0x0006	/* u08 */
#define EEPROM_LOUDNESS		0x0007	/* u08 */
#define EEPROM_TIMEMODE		0x0008	/* u08 */
#define EEPROM_REPEAT		0x0009  /* u08 */

struct DT_elem
{
	u16	song_num;
	u32	dir_block;
};

#define DirsTable ((struct DT_elem*)DIRS_TABLE)
#define MAX_DIRS	255

#endif // __MEM_H__
