/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */

#ifndef ___ISO9660_H
#define ___ISO9660_H

#ifdef YAMPP3USB
 #define SWITCH_PIN	PD2
#else
 #define SWITCH_PIN	PD4
#endif

// Position of BOOT BLOCK on cd in LBA
#define	ISO_BOOT_BLOCK			0x10	/*location on CD*/

// Offset of some data in BOOT BLOCK
#define	ISO_VOL_ID			0x28	/*volume identifier*/
#define	ISO_VOL_ID_LEN			0x20	/*len in bytes*/
#define ISO_PTABLE			0x8c	/*ocurence of L-path table u32*/


struct pathtab {
	BYTE	DirNameLen;
	BYTE	ExtAttr;
	DWORD	DirLoc;
	WORD	DirNumber;
	BYTE	DirName[64];
};

struct direntry {
	BYTE 	LEN_DR;
	BYTE	ExtAtr;
	DWORD	FileLocM;
	DWORD	FileLocL;
	DWORD	FileLenM;
	DWORD	FileLenL;
	BYTE	DateTime[7];
	BYTE	Flags;
#define Flag_NotExist	0x01            /* 1-file not exists */
#define Flag_Directory	0x02            /* 0-normal file, 1-directory */
#define Flag_Associated	0x03            /* 0-not associated file */
#define Flag_Protection	0x04            /* 0-normal acces */
#define Flag_Multi	0x07            /* 0-final Directory Record for the file */
	BYTE	UnitSize;
	BYTE	InterleaveGapSize;
	WORD	VolSeqenceM;
	WORD	VolSeqenceL;
	BYTE	Len_Fi;
	BYTE	FileName[128];
};


#define BUF1			0
#define BUF2 			1
#define DIRLIST_SCAN		1
#define DIRLIST_VERBOSE		2
#define DATA_EXIST		1		// Means that current cluster isn't read 
#define NO_DATA			0		// EOF has been reached


//Function prototypes
u08  ISO_INIT(void);
bool get_dir_entry(u16 entry);
u16  dirlist(u08 mode);
u08  CheckAndAdvanceBlock(void);
bool ReadBuffer(u08 nBuf);

extern bool bBuf1Empty;
extern bool bBuf2Empty;
extern u32  dwFileSize;
extern u08  nLastPosD;
extern u08  nLastEntry;
extern u32  dwCurrentBlock;				// Current being read Block
extern u32  dwBytesLoaded;

#endif

