/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */


;********************************************************************
;*
;*  Delay stuff 
;*  Fixed for a 7.3728 MHz xtal
;*
;********************************************************************

;			r25/r24
;void delay(u16 us) 

.global delay
delay:
		nop			; 3 cycles
		nop
		nop
  		sbiw	r24,1		; 2 cycles
  		brne	delay		; 2 cycles -> 949 nS
 		ret			; +270 nS

.global delay10us
delay10us:
 		clr	r25
 		ldi 	r24,10
 		rjmp 	delay


;			r25/r24
;void delayms(u16 ms)
.global delayms
delayms:
		push 	r24
		push	r25
 		ldi 	r25,hi8(1000)
 		ldi 	r24,lo8(1000)
 		rcall 	delay
		wdr 		
		pop	r25
		pop	r24
 
 		sbiw	r24,1
 		brne	delayms
 		
		ret
