/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */

#ifndef __ATAPI_H__
#define __ATAPI_H__

#include "types.h"
#include "Constants.h"


//----------------------------------------------------------------------------
// Constants...
//----------------------------------------------------------------------------

#define TRUE     1 
#define FALSE    0 
#define CTRL_A	 0x08
#define CMD_A	 0x10

// ATA status register bits
#define SR_BUSY		0x80
#define SR_DRDY		0x40
#define SR_DF		0x20
#define SR_DSC		0x10
#define SR_DRQ		0x08
#define SR_CORR		0x04
#define SR_IDX		0x02
#define SR_ERR		0x01

// ATA error register bits
#define ER_UNC		0x40
#define ER_MC		0x20
#define ER_IDNF		0x10
#define ER_MCR		0x08
#define ER_ABRT		0x04
#define ER_TK0NF	0x02
#define ER_AMNF		0x01

// ATA control register bits
#define CT_SRST			0x04
#define CT_nIEN			0x02

// ATA dev/head register bits
#define DH_CHS0			0xA0
#define DH_CHS1			0xB0

// ATA registers

// Command registers
#define CMD_DATA		0x00
#define CMD_ERROR		0x01
#define CMD_FEATURES		0x01
#define CMD_SECT_CNT		0x02
#define CMD_SECT_NUM		0x03
#define CMD_CYL_LOW		0x04
#define CMD_CYL_HIGH		0x05
#define CMD_DEV_HEAD		0x06
#define CMD_STATUS		0x07
#define CMD_COMMAND		0x07

// Control registers
#define CTRL_ALT_STAT		0x06
#define CTRL_DEV_CTRL		0x06

// Used ATAPI Commands
#define ATAPI_PACKET		0xa0
#define ATAPI_READ12		0xa8
#define ATAPI_SLOWDOWN		0xbb
#define ATAPI_START_STOP_UNIT	0x1b
#define ATAPI_DOOR_LOCK		0x1e
#define ATAPI_REQUEST_SENSE	0x03
#define ATAPI_RESET		0x08
#define ATAPI_MODE_SENSE	0x5A

//ATAPI CMD ERRORS
#define CD_STAT_OK		0x00
#define CD_STAT_ERROR		0x01
#define CD_STAT_NODISK		0x02
#define CD_STAT_UNDEF_ERROR	0x04
#define CD_STAT_NOT_READY	0x08
#define CD_STAT_OPENED		0x18

#define LOAD_CD			3
#define EJECT_CD		2
#define START_CD		1
#define STOP_CD			0


//----------------------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------------------
u08  ATA_Init(void);
void ATA_SW_Reset(void);
void ATAPI_ClearBuf(void);
u08  ATAPI_ReadLBA(u32 LBA, u08 *Buffer);
u08  ATAPI_Command(void);
u08  ATAPI_CheckStatus(void);
u08  ATAPI_Mode_Sense(void);
u08  ATAPI_DA_GetToc(void);
u08  ATAPI_DA_GetTrackN(void);
u16  ATAPI_DA_GetDiscTime(void);
u08  ATAPI_DA_GetM(u08 Track);
u08  ATAPI_DA_GetS(u08 Track);
u08  ATAPI_DA_GetF(u08 Track);
u08  ATAPI_DA_Play(u08 Track);
u08  ATAPI_DA_Stop(void);
u08  ATAPI_DA_PauseResume(bool bResume);
void ATAPI_DA_Scan(bool bDir);
u08  ATAPI_DA_GetSubC(void);
u16  ATAPI_DA_GetCurTime(void);
u08  ATAPI_DA_GetCurTrack(void);
u32  ATAPI_GetIsoToc(void);

void SlowDown(void);
void CD_Cmd(u08 Funct);

// Bytes per sector
#define BPS 2048

#endif // __ATAPI_H__
