/* **********************************************************************
**
**  Copyright (C) 2003  Jesper Hansen <jesperh@telia.com> and 
**			Romuald Bialy (MIS) <romek_b@o2.pl>.
**
*************************************************************************
**
**   This file is part of the yampp system.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License
**  as published by the Free Software Foundation; either version 2
**  of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software Foundation, 
**  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
*********************************************************************** */


/* *********************************************************************
************************************************************************
*****  WARNING !:  RECOMPILE THIS CODE ONLY WITH GCC VERSION 3.4.3 *****
*****       version: WinAVR-20050214-install.exe		   *****
************************************************************************
********************************************************************** */


#ifndef __CONST_H__
#define __CONST_H__

// Here is some constants are defined.

//============================================================================
// BOARD VERSION
//============================================================================
//
// if you have OLD yampp3 board with changed CPU type to ATmega161/162 - 
// comment out the following line
//
#define YAMPP3USB


//============================================================================
// VS1001
//============================================================================
//
// Define F_VS1001 constant according to your VS1001 clock divided by 2000.
// Add 0x8000 if you use clock doubler.
//
#define F_VS1001	(6144 + 0x8000)			/* 12,288MHz x2 */
//#define F_VS1001	(6400 + 0x8000)			/* 12,800MHz x2 */
//#define F_VS1001	(7159 + 0x8000)			/* 14,318MHz x2 */
//#define F_VS1001	(12000 + 0x0000)		/* 24MHz     */
//#define F_VS1001	(12288 + 0x0000)		/* 24.576Mhz */
//
//----------------------------------------------------------------------------
// If you have VS1001 in version older that "K" - uncomment the following line
//
//#define OLD_VS1001


//============================================================================
// LCD
//============================================================================
//
// Define LCD display organisation.
//
#define LCD_TYPE	1		// 2x16 LCD
//#define LCD_TYPE	2		// 2x20 LCD
//#define LCD_TYPE	3		// 2x24 LCD
//#define LCD_TYPE	4		// 4x16 LCD
//#define LCD_TYPE	5		// 4x20 LCD

//----------------------------------------------------------------------------
// In case you need alternative scroll method - uncomment the following line
//
//#define ALTERNATE_SCROLL

//----------------------------------------------------------------------------
// In case you need bitrate displaying on random indicator place, but only if
// random function is turned off - uncomment the following line
//
#define DISPLAY_BITRATE


//============================================================================
// CD-ROM and ATAPI options
//============================================================================
//
// Define CD-ROM read speed in Kbytes/second (1x - 172KB/S, 2x - 353KB/s,
// 4x - 706KB/s, 8x - 1430KB/s, 16x - 2460KB/s). Default speed is 4x.
// If you comment this line your CD-ROM get read at maximum avaliable speed
//
#define READ_SPEED	706		// Kbytes/second !

//----------------------------------------------------------------------------
// If you have problems during CD Audio fast forward/rewind, or during start
// playing - increase this value. Maximum value is about 10.
//
#define DELAY_TIME	1

//----------------------------------------------------------------------------
// This constant defines numbers of seconds to skip during one FFWD and FREW
// search step on Audio CD's.
//
#define CDDA_SCAN_STEP	10


//============================================================================
// SONG NAVIGATION
//============================================================================
// In case you need new Prevous functionality (like in standard CD players) -
// uncomment the following line:
//
#define NEW_PREV


//============================================================================
// Infra Red Controls
//============================================================================
//
// In case you need use an remote IR controller - uncomment the following line
//
#define ENABLE_IR

//----------------------------------------------------------------------------
// If you need setup remote controller codes first uncomment the following
// definition (#define SETUP_REMOTE_CODES), compile the code and download to
// yampp. Next press several times any key on your remote to autorecognize 
// remote standard. If yampp recognize it, you see appropriate message on LCD 
// and UART terminal, and you see standard number for enter to "REM_STD" 
// definition in remote definition file. Next you must copy the sample 
// (!_SAMPLE_BASE.def) file from "REMOTES" folder to source code folder,
// and change it's name to "remote.def". Next you must edit this file and enter
// appropriate codes that you see on LCD and UART terminal after any remote 
// keypress. Next save edited file, comment back SETUP_REMOTE_CODES definition,
// recompile and download full working code to yampp.
// You should copy back the "remote.def" file to "REMOTES" folder and change it's 
// name for use later (and/or send to me for include in next versions of f/w).
//
//#define SETUP_REMOTE_CODES
//
//----------------------------------------------------------------------------
// In case you have a problems with volume keys - comment the following line.
//
#define ENABLE_AUTOREPEAT

//----------------------------------------------------------------------------
// In case you have a problems with double interpretted random, loudness and
// numerical keys - set following constants to 2,3 or 4 
// Note: Increase this slow down AUTOREPEAT function too. 
//
#define DOUBLE_TRAP 1


//============================================================================
// Local keys control and layout definitions
//============================================================================
//
// In case you need use a local keyboard  - uncomment the following line:
//
#define ENABLE_LOCAL_KBD

//----------------------------------------------------------------------------
// Here is local keys layout definitions
//
// Shortpress
//
#define KBD_SHORT { EV_IDLE, EV_FUNCTION, EV_PLAY, EV_NEXT, EV_PREV, EV_NEXTD,  EV_PREVD,  EV_VOLUP, EV_VOLDN };
//
//
// Longpress
//
#define KBD_LONG  { EV_IDLE, EV_FUNCTION, EV_STOP, EV_FFWD, EV_FREW, EV_NEXT10, EV_PREV10, EV_VOLUP, EV_VOLDN };


//============================================================================
// UART
//============================================================================
//
// In case you need serial interface - uncomment the following string:
//
#define ENABLE_SERIAL

//============================================================================
// WATCHDOG
//============================================================================
//
// In case you need watchdog timer - uncomment the following string:
//
#define ENABLE_WATCHDOG


//============================================================================
// APPLICATION
//============================================================================
//
// This constant defines minimum volume level - to decrease unnessesary
// steps in volume control
// note that 0 is max volume and 0xff is minimum volume
//
#define MIN_VOLUME 	0x60

//----------------------------------------------------------------------------
// number of volume steps 
//
#define NUM_VOL_STEPS	24

//----------------------------------------------------------------------------
// In case you can hear three power up beeps - uncomment the following line:
//
//#define PWR_BEEPS


//============================================================================
// SLEEP TIMER
//============================================================================

//#define ENABLE_SLEEP_TIMER

// Here is definition of sleep timer timeout output pin. After timeout, yampp
// shorts this pin to GND (force low level). Now is assigned into infrared input
// pin, because i have some external hardware used as yampp standby unit
// controlled via infrared. This unit send all other IR command into yampp,
// and check this output for low-level forcing.

#ifdef YAMPP3USB
 #define TIMER_PORT	PORTE
 #define TIMER_DDR	DDRE
 #define TIMER_PIN	PE0
#else
 #define TIMER_PORT	PORTD
 #define TIMER_DDR	DDRD
 #define TIMER_PIN	PD2
#endif


//============================================================================
// National characters replacing table (from UNICODE to standard chars)
//============================================================================
//
// This is Polish version of table.
// table format is:	{u16 UNICODE, u08 standard_code}
//
#define NATIONAL_DEF {	{0x0105,'a'},	\
			{0x0107,'c'},	\
			{0x0119,'e'},	\
			{0x0142,'l'},	\
			{0x0144,'n'},	\
			{0x00f3,'o'},	\
			{0x015b,'s'},	\
			{0x017a,'z'},	\
			{0x017c,'z'},	\
			{0x0104,'A'},	\
			{0x0106,'C'},	\
			{0x0118,'E'},	\
			{0x0141,'L'},	\
			{0x0143,'N'},	\
			{0x00d3,'O'},	\
			{0x015a,'S'},	\
			{0x0179,'Z'},	\
			{0x017b,'Z'}	};


//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


//
//
// Some checks and calculations, DONT change this !
//

#ifndef GCC_VERSION
 #define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif /* GCC_VERSION */

#if (GCC_VERSION != 3004)
 #error __Wrong compiler version. Use GCC 3.4.3 !___
#endif

#define F_CPU	7372800				/* 7,3728MHz CPU quartz */


#ifdef SETUP_REMOTE_CODES
 #define ENABLE_SERIAL
 #define PWR_BEEPS
 #define SHOW_REMOTE_CODES
#endif

#define VOL_STEP	( (MIN_VOLUME + 1) / NUM_VOL_STEPS )

#if (LCD_TYPE == 1)
 #define LCD_LINES 2
 #define LCD_LINE_LENGTH 16
#endif
#if (LCD_TYPE == 2)
 #define LCD_LINES 2
 #define LCD_LINE_LENGTH 20
#endif
#if (LCD_TYPE == 3)
 #define LCD_LINES 2
 #define LCD_LINE_LENGTH 24
#endif
#if (LCD_TYPE == 4)
 #define LCD_LINES 4
 #define LCD_LINE_LENGTH 16
#endif
#if (LCD_TYPE == 5)
 #define LCD_LINES 4
 #define LCD_LINE_LENGTH 20
#endif

#if F_CPU < 4000000 || F_CPU > 12000000
#error Invalid F_CPU!
#endif

#if F_VS1001 < 10000 || F_VS1001 > 65536
#error Invalid F_VS1001!
#endif

#endif // __CONST_H__
