#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <avr/eeprom.h>
#include <avr/pgmspace.h>
#include <inttypes.h>
#include <avr/wdt.h>
#include "TM1637_avr.h"
#include "global_tim.h"
#include "buttons_avr.h"
#include "encoder_avr.h"
#include "bits_macros.h"
#include "preobr_tim.h"
#include "ini_t1.h"

//----------------------------------------------------
volatile static union
{
uint8_t flag_upr;
bit_struct flag_uprs;
}fl;
/*
fl.flag_uprs.B0 -    TIM1
fl.flag_uprs.B1 -  
fl.flag_uprs.B2 -  1
fl.flag_uprs.B3 -   
fl.flag_uprs.B4 -    ,     
fl.flag_uprs.B5 -  ,   
fl.flag_uprs.B6 -   
fl.flag_uprs.B7 -     led
*/
//----------------------------------------------------

uint16_t EEMEM chislo_tikov_ee;
uint8_t EEMEM mas_ms_ee[16]; 
uint8_t EEMEM mas_hm_ee[16];
uint8_t EEMEM yarkost_ee;
uint8_t EEMEM mode_ee;

//------------------------------------------------------------
ISR(TIMER1_COMPA_vect)
{
fl.flag_uprs.B0=1;
}
//-----------------------------------------------------------------------

int main(void)
{
//-----------------------------------------------------------------------  
 //    
static uint8_t temp_main_one;
static uint8_t dvoetochie=0;
static uint8_t temp_buzz;
static uint8_t temp_led;
static uint16_t temp_main_two;
static uint8_t vibor;
static uint8_t yarkost;
static uint8_t mode;
static uint8_t schet_tm;
static uint8_t otmena_scheta=0;
static uint8_t temp_main_three;
static uint16_t chislo_tikov;

uint8_t enc, kn_1, kn_2;
static uint8_t mass_tm[4];
static uint8_t mas_ms[16];
static uint8_t mas_hm[16];
smh_data static data_post, data_izm;
//-----------------------------------------------------------------------
ini_t1();
button_init();
ENC_InitEncoder();
tm1637_init();

//   ------------------------
out_off;
chislo_tikov=eeprom_read_word(&chislo_tikov_ee);
if(chislo_tikov>MAX_CHISLO_TIKOV) chislo_tikov=VREMYA_SECUNDI;
mode=eeprom_read_byte(&mode_ee);
if(mode>0) mode=1;
yarkost=eeprom_read_byte(&yarkost_ee);
tm1637_brightness(yarkost);

for(temp_main_one=0;temp_main_one<16;temp_main_one++) 
	{
	mas_ms[temp_main_one]=eeprom_read_byte(&mas_ms_ee[temp_main_one]);
	prov_mas(mas_ms);
	mas_hm[temp_main_one]=eeprom_read_byte(&mas_hm_ee[temp_main_one]);
	prov_mas(mas_hm);
	}
if(mode)
	{
	data_post.minute= mas_ms[0];
	data_post.second=mas_ms[1];
	prov_min_sec(&data_post);
	preobr_minmass(mass_tm, &data_post);
	}
else
	{
	data_post.hour=mas_hm[0];
	data_post.minute=mas_hm[1];
	prov_hour_minute(&data_post);
	preobr_hourmass(mass_tm, &data_post);
	}
vibor=VIBOR_ZNACH;
tm1637_write_paket(mass_tm, 1);
//--------------------------------------------------------
sei();
//-----------------------------------------------------------------------------
while(1)  
{
//*********************************************************************  
if(fl.flag_uprs.B0 && (fl.flag_uprs.B3==0))
	{
	fl.flag_uprs.B0=0;
	but_debrief();
	but_debrief_povtor();
	kn_2=but_debrief_long();
	kn_1=but_getkey();	
	ENC_PollEncoder();
	enc=ENC_GetStateEncoder();
	schet_tm++;
	if(fl.flag_uprs.B7)
		{
		temp_main_three=led_miganie(DLIT_SVECHENI_LED);
		if(temp_main_three==1) fl.flag_uprs.B7=0;
		}
	}
	wdt_reset();
//---------------------------------------------------------------
if(fl.flag_uprs.B5==0)
	{	
	if(kn_1==KEY_UP)	
		{
		fl.flag_uprs.B7=1;	
		vibor++;	
		if(vibor>VIBOR_MAX) vibor=VIBOR_MAX;
		fl.flag_uprs.B4=0;
		}
	if(kn_1==KEY_DOWN)	
		{
		fl.flag_uprs.B7=1;
		vibor--;	
		if(vibor<VIBOR_MIN) vibor=VIBOR_MIN;
		fl.flag_uprs.B4=0;
		}
	if((kn_1==KEY_DOWN) || (kn_1==KEY_UP))
	{
	if(vibor>=VIBOR_ZNACH) 
		{
		if(mode)
			{
			izm_vib_post(&data_post, mas_ms, vibor);
			preobr_minmass(mass_tm, &data_post);
			}
		else
			{
			izm_vib_post_hour(&data_post, mas_hm, vibor);
			preobr_hourmass(mass_tm, &data_post);
			}
		}
	}
	if(vibor==14)//
		{
		mass_tm[0]=SIMV_P;
		mass_tm[1]=SIMV_Y;
		mass_tm[2]=SIMV_tire;
		if(yarkost>7) mass_tm[3]=SIMV_E;
		else mass_tm[3]=tm1637_perecod(yarkost);	
		}
	if(vibor==13)//  mode - ,   , 
		{
		mass_tm[0]=SIMV_P;
		mass_tm[1]=SIMV_r;
		mass_tm[2]=SIMV_tire;
		if(mode==0) mass_tm[3]=DIG_0;
		else mass_tm[3]=DIG_1;		
		}
	if(vibor==VIBOR_MAX)
		{
		mass_tm[0]=SIMV_E;
		mass_tm[1]=SIMV_n;
		mass_tm[2]=SIMV_d;
		mass_tm[3]=0;	
		}		
	}	
//-----------------------------------------------------------------------------------
	if(kn_2==KEY_ENCODER) 
		{
		fl.flag_uprs.B4^=1;
		fl.flag_uprs.B7=1;
		}
	//-------------------------------------------------------------
	if(enc)
	{
	if((vibor>=VIBOR_ZNACH) && (vibor<VIBOR_MAX))
		{
		if(enc==LEFT_SPIN)
			{
			if(mode)
				{
				if(fl.flag_uprs.B4) data_post.second--;
				else data_post.minute--;
				}
			else
				{
				if(fl.flag_uprs.B4) data_post.minute--;
				else data_post.hour--;			
				}
			}
		else
			{
			if(mode)
				{
				if(fl.flag_uprs.B4) data_post.second++;
				else data_post.minute++;
				}
			else
				{
				if(fl.flag_uprs.B4) data_post.minute++;
				else data_post.hour++;			
				}
			}
		if(mode) prov_min_sec(&data_post);
		else prov_hour_minute(&data_post);
		}	
	if(mode) preobr_minmass(mass_tm, &data_post);
	else preobr_hourmass(mass_tm, &data_post);
	
	if(vibor==(VIBOR_ZNACH-1))// 
		{
		if(enc==LEFT_SPIN) yarkost--;
		else yarkost++;
		if(yarkost>7 && yarkost<=200) yarkost=7;
		if(yarkost>200) yarkost=0;
		tm1637_brightness(yarkost);
		mass_tm[0]=SIMV_P;
		mass_tm[1]=SIMV_Y;
		mass_tm[2]=SIMV_tire;
		mass_tm[3]=tm1637_perecod(yarkost);	
		}
	if(vibor==(VIBOR_ZNACH-2))//  mode - ,   , 
		{
		if(enc==LEFT_SPIN) mode=0;
		else mode=1;
		mass_tm[0]=SIMV_P;
		mass_tm[1]=SIMV_r;
		mass_tm[2]=SIMV_tire;
		mass_tm[3]=tm1637_perecod(mode);		
		}
	}

//--------------------------------------------------------------
if((kn_1==KEY_ENTER) && (vibor>=VIBOR_ZNACH) && (vibor!=VIBOR_MAX) && (fl.flag_uprs.B2==0)) 
{
fl.flag_uprs.B1=1;
fl.flag_uprs.B5=1;
kn_1=0;
}
if((kn_2==KEY_ENCODER_DLIT) && ((vibor==13) || (vibor==14)))
	{
	fl.flag_uprs.B7=1;
	mass_tm[0]=SIMV_tire;
	mass_tm[1]=SIMV_tire;
	mass_tm[2]=SIMV_tire;
	mass_tm[3]=SIMV_tire;
	tm1637_write_paket(mass_tm, 1);
	while(!((pin_button_u) & (1<<ENCODER))) {wdt_reset();}
	cli();
	eeprom_update_byte(&yarkost_ee, yarkost);
	eeprom_update_byte(&mode_ee, mode);
	sei();
	if(vibor==(VIBOR_ZNACH-1))
		{
		mass_tm[0]=SIMV_P;
		mass_tm[1]=SIMV_Y;
		mass_tm[2]=SIMV_tire;
		mass_tm[3]=tm1637_perecod(yarkost);
		}
	if(vibor==(VIBOR_ZNACH-2))
		{
		mass_tm[0]=SIMV_P;
		mass_tm[1]=SIMV_r;
		mass_tm[2]=SIMV_tire;
		mass_tm[3]=tm1637_perecod(mode);
		}
}
//*****************************************************************
if(fl.flag_uprs.B1)
	{
	data_izm.hour=data_post.hour;
	data_izm.minute=data_post.minute;	
	if(mode) 
		{
		mas_ms[(vibor-VIBOR_ZNACH)*2]=data_post.minute;
		mas_ms[(vibor-VIBOR_ZNACH)*2+1]=data_post.second;
		data_izm.second=data_post.second;
		}
	else
		{
		mas_hm[(vibor-VIBOR_ZNACH)*2]=data_post.hour;
		mas_hm[(vibor-VIBOR_ZNACH)*2+1]=data_post.minute;
		data_izm.second=MAX_SECONDS;
		}	
	fl.flag_uprs.B1=0;
	fl.flag_uprs.B2=1;
	temp_main_two=0;
	out_on;
	led_on;
	}
//-----------------------------------------------
if(fl.flag_uprs.B2)
{
if(kn_1==KEY_CANCEL)
	{ 
	otmena_scheta++;
	out_off;
	}
if(kn_1==KEY_ENTER) 
	{
	otmena_scheta=0;
	out_on;
	}
if(otmena_scheta==0)
	{
	if(mode)
	{
	if(((data_izm.minute)==0) && ((data_izm.second)==0))
		{
		fl.flag_uprs.B2=0;
		fl.flag_uprs.B3=1;
		}
	}
	else
	{
	if(((data_izm.hour)==0) && ((data_izm.minute)==0))
		{
		fl.flag_uprs.B2=0;
		fl.flag_uprs.B3=1;
		}	
	}
	temp_main_two++;
	if(temp_main_two==chislo_tikov)
		{
		temp_main_two=0;
		if(mode) preobr_dec_min(&data_izm);
		else preobr_dec_hour(&data_izm);

		if(dvoetochie) dvoetochie=0;
		else dvoetochie=1;
		if(mode) preobr_minmass(mass_tm, &data_izm);
		else preobr_hourmass(mass_tm, &data_izm);
		tm1637_write_paket(mass_tm, dvoetochie);
		}
	}
if(otmena_scheta==2)
{
fl.flag_uprs.B2=0;
fl.flag_uprs.B5=0;
out_off;
led_off;
if(mode)
	{
	izm_vib_post(&data_post, mas_ms, vibor);
	preobr_minmass(mass_tm, &data_post);
	}
else
	{
	izm_vib_post_hour(&data_post, mas_hm, vibor);
	preobr_hourmass(mass_tm, &data_post);
	}
otmena_scheta=0;
}
}
//------------------------------------------------
if(fl.flag_uprs.B3)
{
buzzer_on;
temp_buzz++;
temp_led++;
out_off;
fl.flag_uprs.B0=0;
if(temp_buzz==TEMP_BUZZER) 
	{
	temp_buzz=0;
	buzzer_toggle;
	}
if(temp_led==TEMP_LED) 
	{
	temp_led=0;
	led_toggle;
	}
if((pin_button_u & (MASK_BUTTONS))!=(MASK_BUTTONS))
	{
	while((pin_button_u & (MASK_BUTTONS))!=(MASK_BUTTONS)) {wdt_reset();}
	fl.flag_uprs.B3=0;
	fl.flag_uprs.B5=0;
	buzzer_off;
	led_off;
	out_off;
	fl.flag_uprs.B4=0;
	cli();
	if(mode)
		{
		eeprom_update_byte(&mas_ms_ee[((vibor-VIBOR_ZNACH)*2)], data_post.minute);
		eeprom_update_byte(&mas_ms_ee[((vibor-VIBOR_ZNACH)*2+1)], data_post.second);
		preobr_minmass(mass_tm, &data_post);
		}
	else
		{
		eeprom_update_byte(&mas_hm_ee[((vibor-VIBOR_ZNACH)*2)], data_post.hour);
		eeprom_update_byte(&mas_hm_ee[((vibor-VIBOR_ZNACH)*2+1)], data_post.minute);
		preobr_hourmass(mass_tm, &data_post);	
		}
	sei();
	}		
}
//-------------------------------------------------
if((schet_tm>MAX_SCHET_TM) && (fl.flag_uprs.B2==0))
	{
	schet_tm=0;
	if(vibor==VIBOR_MAX) tm1637_write_paket(mass_tm, 0);
	else tm1637_write_paket(mass_tm, 1);
	}
sleep_cpu();
 
}//while(1)     
  return 0;
}//int main( void )




























