#include <inttypes.h>
#include <avr/io.h>
#include <avr/sleep.h>
#include <avr/wdt.h>
#include "ini_t1.h"
#include "global_tim.h"

//----------------------------------------------------------------
void ini_t1(void)
{
ACSR=0x80;		// 
//******************************************************************
//   
PORTD |= (1<<0) | (1<<1) | (1<<2) | (1<<3) | (1<<4) | (1<<6);
// 
DDRB |=(1<<0) | (1<<1);
PORTC |=(1<<4);
DDRC |=(1<<3) | (1<<4);
//******************************************************************
//      
PORTD |= (1<<7);
PORTB |= (1<<2) | (1<<3) | (1<<4) | (1<<5);
PORTC |= (1<<2) | (1<<5);
//******************************************************************
//  1 
OCR1AH=(uint8_t) (ZNACH_OCR>>8);
OCR1AL=(uint8_t) ZNACH_OCR;
//TCCR1A |=
TCCR1B |=(1<<WGM12) | (1<<CS11);//  8,  
//TCNT1H and TCNT1L
//OCR1BH and OCR1BL
//ICR1H and ICR1L
TIMSK |=(1<<OCIE1A);// 
//TIFR
//*******************************************************************
//    ,   2100 .
 WDTCR |=(1<<WDE) | (1<<WDP0) | (1<<WDP1) | (1<<WDP2);
wdt_reset(); 
//*****************************************************************
//  
set_sleep_mode(SLEEP_MODE_IDLE);
sleep_enable();
//******************************************************************
}
//------------------------------------------------------------------
//   
uint8_t led_miganie(uint8_t dlitelnost)
{
static uint8_t dlit_lm;
static uint8_t dlit_l=0;

if(dlit_l==0) 
	{
	dlit_lm=dlitelnost;
	dlit_l=1;
	led_on;
	}
if(dlit_l==1) 
	{
	dlit_lm--;
	}
if(dlit_lm==0)
{
dlit_l=0;
led_off;
return 1;
}
else return 0;
}
//------------------------------------------------------------------








