#ifndef TM1637_AVR_H
#define TM1637_AVR_H

//   ---------------------------
#define tm_ddr DDRC
#define tm_port PORTC
#define tm_pin PINC
#define DIO_PIN 0
#define CLK_PIN 1
//-------------------------------------------------------

#define ZAD_ZAPISI 3 // 
#define ZAD_CHTENIYA 10 
#define DELAY_2 2
#define DELAY_5 5
#define DELAY_30 30


#define COMM_INIT 0x89 // 3     
#define COMM_PEREDACHI_FIX 0x44
#define COMM_CHTENIYA_KLAVI 0x42
#define COMM_PEREDACHI_PAKET 0x40
#define ADRESS_PERV_ZNAKOMESTA 0xC0


#define DIG_0 0x3f
#define DIG_1 0x06
#define DIG_2 0x5b
#define DIG_3 0x4f
#define DIG_4 0x66
#define DIG_5 0x6d
#define DIG_6 0x7d
#define DIG_7 0x07
#define DIG_8 0x7f
#define DIG_9 0x6f

#define SIMV_A 0x77
#define SIMV_b 0x7c
#define SIMV_rusB 0x7D
#define SIMV_C 0x39
#define SIMV_c 0x58
#define SIMV_d 0x5e
#define SIMV_E 0x79
#define SIMV_F 0x71
//#define SIMV_G 0x00 
#define SIMV_H 0x76
#define SIMV_h 0x74
#define SIMV_i 0x04
#define SIMV_n 0x54
#define SIMV_P 0x73
#define SIMV_r 0x50
#define SIMV_t 0x38
#define SIMV_U 0x3E
#define SIMV_u 0x1C
#define SIMV_Y 0x6E
#define SIMV_gradus  0x63
#define SIMV_tire 0x40

/*
     ( )
S1 (SG1, K1) - 239
S2 (SG1, K2) - 247
S3 (SG5, K2) - 215
S4 (SG5, K1) - 207
S5 (SG2, K1) - 111
S6 (SG2, K2) - 119
S7 (SG6, K2) - 151
S8 (SG6, K1) - 79
S9 (SG3, K1) - 175
S10 (SG3, K2) - 215
S11 (SG7, K2) - 151
S12 (SG7, K1) - 143
S13 (SG4, K1) - 47
S14 (SG4, K2) - 55
S15 (SG8, K2) - 23
S16 (SG8, K1) - 15
*/

void tm1637_init(void);
void tm1637_write_fix(uint8_t fix_data, uint8_t pologenie);
void tm1637_write_paket(uint8_t *paket_data, uint8_t dvoetochie);
void tm1637_write_paket_point(uint8_t *paket_data, uint8_t polog_tochki);
uint8_t tm1637_chtenie_klavi(void);
void tm1637_brightness(uint8_t yarkost);
void tm1637_on_off(uint8_t onoff);
uint8_t tm1637_perecod(uint8_t simvol);

#endif //TM1637_AVR_H
