#include <inttypes.h>
#include <util/delay.h>
#include <avr/io.h>
#include "TM1637_avr.h"

static void tm1637_start(void);
static void tm1637_stop(void);
static void tm1637_ask(void);
static void tm1637_write_byte(uint8_t wr_data);


//-------------------------------------------------------------
void tm1637_init(void)
	{
	  tm_ddr |=(1<<DIO_PIN | 1<<CLK_PIN); //  
	  tm_port |=(1<<DIO_PIN | 1<<CLK_PIN);
	  tm1637_start();
	  tm1637_write_byte(COMM_INIT);
	  tm1637_stop();
	}	
//-------------------------------------------------------------
static void tm1637_start(void)
	{
	tm_port |=(1<<CLK_PIN);
	tm_port |=(1<<DIO_PIN);
	_delay_us(DELAY_2);
	tm_port &=~(1<<DIO_PIN);
	}
//--------------------------------------------------------------
static void tm1637_stop(void)
	{
	tm_port &=~(1<<CLK_PIN);
	_delay_us(DELAY_2);
	tm_port &=~(1<<DIO_PIN);
	_delay_us(DELAY_2);
	tm_port |=(1<<CLK_PIN);
	_delay_us(DELAY_2);
	tm_port |=(1<<DIO_PIN);
	}
//-------------------------------------------------------------
static void tm1637_ask(void)
	{
	tm_port &=~(1<<CLK_PIN);
	_delay_us(DELAY_5);
	tm_ddr &=~(1<<DIO_PIN);
	//while(!(tm_pin & (1<<DIO_PIN))); 
	tm_port |=(1<<CLK_PIN);
	_delay_us(DELAY_2);
	tm_port &=~(1<<CLK_PIN);
	tm_ddr |=(1<<DIO_PIN);
	}
//---------------------------------------------------------
static void tm1637_write_byte(uint8_t wr_data)
{
uint8_t i; 

  for(i=0;i<8;i++)        //send 8bit data
  {
    tm_port &=~(1<<CLK_PIN);      
    if(wr_data & 0x01) tm_port |=(1<<DIO_PIN);//LSB first
    else tm_port &=~(1<<DIO_PIN);
	_delay_us(ZAD_ZAPISI);
    wr_data >>= 1;      
    tm_port |=(1<<CLK_PIN);
	_delay_us(ZAD_ZAPISI);      
  }
  
tm1637_ask();
}
//-------------------------------------------------------------
//pologenie -   (1....4)
void tm1637_write_fix(uint8_t fix_data, uint8_t pologenie)
	{
	if(pologenie<1 || pologenie>4) return;
	tm1637_start();
	tm1637_write_byte(COMM_PEREDACHI_FIX);
	tm1637_stop();
	tm1637_start();
	tm1637_write_byte(0xC0+pologenie-1);
	tm1637_write_byte(fix_data);
	tm1637_stop();
	}
//-----------------------------------------------------------
// "" 
//*paket_data -    4- ,      (),
//dvoetochie -   0,   ,    ( 255) -  
void tm1637_write_paket(uint8_t *paket_data, uint8_t dvoetochie)
	{
	uint8_t a;

	if(dvoetochie) paket_data[1] |=0x80;
	else paket_data[1] &=0x7F;

	tm1637_start();
	tm1637_write_byte(COMM_PEREDACHI_PAKET);
	tm1637_stop();
	tm1637_start();
	tm1637_write_byte(ADRESS_PERV_ZNAKOMESTA);

	for(a=0;a<4;a++) tm1637_write_byte(paket_data[a]);

	tm1637_stop();
	}
//--------------------------------------------------------
// ,   
//*paket_data -    4- ,      (),
//polog_tochki -   1  4,    -   
void tm1637_write_paket_point(uint8_t *paket_data, uint8_t polog_tochki)
{

uint8_t b;

switch(polog_tochki)
	{
	case 1: paket_data[0] |=0x80; paket_data[1] &=0x7F; paket_data[2] &=0x7F; paket_data[3] &=0x7F;break;
	case 2: paket_data[1] |=0x80; paket_data[0] &=0x7F; paket_data[2] &=0x7F; paket_data[3] &=0x7F;break;
	case 3: paket_data[2] |=0x80; paket_data[1] &=0x7F; paket_data[0] &=0x7F; paket_data[3] &=0x7F;break;
	case 4: paket_data[3] |=0x80; paket_data[1] &=0x7F; paket_data[2] &=0x7F; paket_data[0] &=0x7F;break;
	default: paket_data[3] &=0x7F;paket_data[1] &=0x7F; paket_data[2] &=0x7F; paket_data[0] &=0x7F;	
	}

tm1637_start();
tm1637_write_byte(COMM_PEREDACHI_PAKET);
tm1637_stop();
tm1637_start();
tm1637_write_byte(ADRESS_PERV_ZNAKOMESTA);

for(b=0;b<4;b++) tm1637_write_byte(paket_data[b]);

tm1637_stop();
}
//------------------------------------------------------------
// 
//         - .h.   0xFF,    
uint8_t tm1637_chtenie_klavi(void)
	{
	uint8_t j; 
	uint8_t kod_klavi;

	kod_klavi=0;

	tm1637_start();
	tm1637_write_byte(COMM_CHTENIYA_KLAVI);

	tm_ddr &=~(1<<DIO_PIN);

	_delay_us(DELAY_30);

	for(j=0;j<8;j++)        
	  {
	  tm_port |=(1<<CLK_PIN);
	  kod_klavi<<=1;
	  _delay_us(DELAY_30);
	  if(tm_pin & (1<<DIO_PIN)) kod_klavi++;
	  _delay_us(DELAY_30);
	   tm_port &=~(1<<CLK_PIN);  
	  }
	  
	tm1637_ask();
	tm1637_stop();

	return kod_klavi;
	}
//-------------------------------------------------------------
//8  , yarkost=(0....7)
void tm1637_brightness(uint8_t yarkost)
	{
	if(yarkost>7) yarkost=7;
	yarkost+=0x88;
	tm1637_start();
	tm1637_write_byte(yarkost);
	tm1637_stop();
	}
//-------------------------------------------------------------
//,  .  0 - ,   ( 255) - 
void tm1637_on_off(uint8_t onoff)
	{
	tm1637_start();
	if(onoff) tm1637_write_byte(0x89);
	else tm1637_write_byte(0x80); 
	tm1637_stop();  
	}
//-------------------------------------------------------------
uint8_t tm1637_perecod(uint8_t simvol)
{
switch(simvol)
	{
	case 0: simvol=DIG_0;break;
	case 1: simvol=DIG_1;break;
	case 2: simvol=DIG_2;break;
	case 3: simvol=DIG_3;break;
	case 4: simvol=DIG_4;break;
	case 5: simvol=DIG_5;break;
	case 6: simvol=DIG_6;break;
	case 7: simvol=DIG_7;break;
	case 8: simvol=DIG_8;break;
	case 9: simvol=DIG_9;break;	
	case '0': simvol=DIG_0;break;
	case '1': simvol=DIG_1;break;
	case '2': simvol=DIG_2;break;
	case '3': simvol=DIG_3;break;
	case '4': simvol=DIG_4;break;
	case '5': simvol=DIG_5;break;
	case '6': simvol=DIG_6;break;
	case '7': simvol=DIG_7;break;
	case '8': simvol=DIG_8;break;
	case '9': simvol=DIG_9;break;
	case 'A': simvol=SIMV_A;break;
	case 'b': simvol=SIMV_b;break;
	case 'B': simvol=SIMV_rusB;break;
	case 'C': simvol=SIMV_C;break;
	case 'c': simvol=SIMV_c;break;
	case 'd': simvol=SIMV_d;break;
	case 'E': simvol=SIMV_E;break;
	case 'F': simvol=SIMV_F;break;
	//case 'G': simvol=SIMV_G;break;
	case 'g': simvol=SIMV_gradus;break;
	case 'H': simvol=SIMV_H;break;
	case 'h': simvol=SIMV_h;break;
	case 'i': simvol=SIMV_i;break;
	case 'K': simvol=SIMV_gradus;break;
	case 'P': simvol=SIMV_P;break;
	case 'r': simvol=SIMV_r;break;
	case 't': simvol=SIMV_t;break;
	case 'U': simvol=SIMV_U;break;
	case 'u': simvol=SIMV_u;break;
	case 'Y': simvol=SIMV_Y;break;
	case '-': simvol=SIMV_tire;break;
	default: simvol=0;	
	}
return 	simvol;
}

