#include <stdio.h>
#include <wchar.h>
#include <string.h>
#include <stdlib.h>
#include "hidapi.h"

// Headers needed for sleeping.
#ifdef _WIN32
	#include <windows.h>
#else
	#include <unistd.h>
#endif

int main(int argc, char* argv[])
{
	int res;
	unsigned char buf[256];
	#define MAX_STR 255
	wchar_t wstr[MAX_STR];
	hid_device *handle;
	int i;

#ifdef WIN32
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
#endif

	struct hid_device_info *devs, *cur_dev;
	
	if (hid_init())
		return -1;

	devs = hid_enumerate(0x0, 0x0);
	cur_dev = devs;	
	while (cur_dev) {
		printf("Device Found\n  type: %04hx %04hx\n  path: %s\n  serial_number: %ls", cur_dev->vendor_id, cur_dev->product_id, cur_dev->path, cur_dev->serial_number);
		printf("\n");
		printf("  Manufacturer: %ls\n", cur_dev->manufacturer_string);
		printf("  Product:      %ls\n", cur_dev->product_string);
		printf("  Release:      %hx\n", cur_dev->release_number);
		printf("  Interface:    %d\n",  cur_dev->interface_number);
		printf("\n");
		cur_dev = cur_dev->next;
	}
	hid_free_enumeration(devs);

	// Set up the command buffer.
	memset(buf,0x00,sizeof(buf));
	
	// Open the device using the VID, PID, and optionally the Serial number.
	printf("Connecting to device...\n");
	handle = hid_open(0xc410, 0x0001, NULL);
	if (!handle) {
		printf("unable to open device\n");
	}
	else {
		printf("Connection success.\n");

		// Set the hid_read() function to be non-blocking.
		hid_set_nonblocking(handle, 0);

		// Try to read from the device. There shoud be no
		// data here, but execution should not block.
		printf("Waiting for input...\n");
		res = hid_read(handle, buf, 8);
		printf("Input received\n");
		for (i = 0; i < 8; i++)
			printf("%02X ", buf[i]);
		printf("\n");

		printf("Sending data to device...\n");
		buf[0] = 0x1;		// endpoint number
		buf[1] = 0x1;
		buf[2] = 0x2;
		buf[3] = 0x3;
		buf[4] = 0x4;
		buf[5] = 0x5;
		buf[6] = 0x6;
		buf[7] = 0x7;
		buf[8] = 0x8;
		res = hid_write(handle, buf, 10);
		if (res < 0)
			printf("Unable to write() (2)\n");
		else
			printf("Data sent.\n");

		hid_close(handle);

		/* Free static HIDAPI objects. */
		hid_exit();
	}
#ifdef WIN32
	system("pause");
#endif
	return 0;
}
