//#include <MKL03Z4.h> 
#include "hardware.h"
#include "rx8900.h"

uint8_t time[3];							// [0] = second, [1] = minute, [2] = hour 
uint8_t alTime[3];							// alarm time: [0] = minute [1] = hour

void RX8900_setup(void)
{ 
	uint8_t alarm[] = {0x0A, 0x7F};			// alarm any day of week
	uint8_t flags[] = {0x0E, 0x00, 0xC0};	// flags register
	uint8_t swoff[] = {0x18, 0x0C};			// backup function
	delay(50);
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, flags, 1);
	I2CMasterReadBuf(RX8900_SLAVE_ADDRESS, time, 1);
	
	while (time[0] & 0x02)					// wait for VLF bit to reset
	{
		I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, flags, 2);
		delay(50);
		I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, flags, 1);
		I2CMasterReadBuf(RX8900_SLAVE_ADDRESS, time, 1);
	}	
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, alarm, 2);  // preset for alarm
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, flags, 3);  // clear all flags
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, swoff, 2);	// disable VDD monitor
	alTime[0] = 0x08;						// alarm minutes register address	
	alTime[2] = 0x24;						// disable alarm
}

void RX8900_getTime(void)
{
	uint8_t reg[] = {0x00}; 				// seconds register 
	uint8_t clr[] = {0x0E, 0};
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, reg, 1);
	I2CMasterReadBuf(RX8900_SLAVE_ADDRESS, time, 3);
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, clr, 2); // rest flag
}

void RX8900_setTime(void)
{
	time[0] = 1;							// minutes register
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, time, 3);
}

void RX8900_setAlarm(void)
{
	uint8_t flags[] = {0x0E, 0x00, 0xC8};	// flags register
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, alTime, 3);
	if (alTime[2] >= 0x24)					// do not set alarm
		flags[2] = 0xC0;					// for illegal time
	I2CMasterWriteBuf(RX8900_SLAVE_ADDRESS, flags, 3);	
}

