#include <MKL03Z4.h> 
#include "hardware.h"
#include "max6950.h"

const uint8_t seg_table[] = {0x7E, 0x30, 0x6D, 0x79, 0x33, 0x5B, 0x5F, 0x70, 0x7F, 0x7B};
const uint8_t acl[] = {0x77, 0x4E, 0x0E}; 		// 'A', 'C', 'L' characters
void MAX6950_setup(void)
{
	PTB->PSOR = 1 << PWR;
	delay(500);
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x80) | PORT_GPCLR_GPWD(0x300); 	// configure PA.7 for SPI
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x01) | PORT_GPCLR_GPWD(0x300); 	// configure PB.0 for SPI
	SPI0->C1 = 0x50;							// enable SPI system in master mode	
	Send_MAX6950(0x100);						// no decoding for digits
	Send_MAX6950(0x200);						// set intensity
	Send_MAX6950(0x303);						// scan digits 0 - 3
	Send_MAX6950(0x429);						// blinking, normal mode, reset
	SPI0->C1 = 0x00;							// disable SPI system
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x80) | PORT_GPCLR_GPWD(0x100); 	// configure PA.7 for GPIO
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x01) | PORT_GPCLR_GPWD(0x100); 	// configure PB.0 for GPIO	
}

void Display_Time()
{
	PTB->PSOR = 1 << PWR;						// power up MAX6950
	PTA->PSOR = 1 << CS;						// CS up
	delay(200);									// power-up delay	
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x80) | PORT_GPCLR_GPWD(0x300); 	// configure PA.7 for SPI
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x01) | PORT_GPCLR_GPWD(0x300); 	// configure PB.0 for SPI
	SPI0->C1 = 0x50;							// enable SPI system in master mode	

	Send_MAX6950(0x100);						// no decoding for digits 1 - 4
	Send_MAX6950(0x200);						// set intensity
	Send_MAX6950(0x303);						// scan digits 0 - 3

	Update_Time();
}

void Update_Time()
{	
	uint8_t uh, tm;
	if (time[2] <= 9)
		Send_MAX6950(0x6300);					// no leading 0	
	else
		Send_MAX6950(0x6300 + seg_table[time[2] >> 4]); // display tens of hours
	uh = seg_table[time[2] & 0x0F];				// units of hours
	tm = seg_table[time[1] >> 4];				// tens of minutes
	if (alTime[2] == 0x24)						// no alarm set - blink the dots
	{	
		Send_MAX6950(0x2200 + uh);				// display units of hours
		Send_MAX6950(0x4280 + uh);				// display units of hours + dot
		Send_MAX6950(0x2000 + tm);				// display tens of minutes
		Send_MAX6950(0x4080 + tm);				// display tens of minutes + dot		
	}
	else										// alarm is set - don't blink the dots
	{	
		Send_MAX6950(0x6280 + uh);				// display units of hours + dot
		Send_MAX6950(0x6080 + tm);				// display tens of minutes + dot
	}
	Send_MAX6950(0x6100 + seg_table[time[1] & 0x0F]);	// display units of minutes
	Send_MAX6950(0x409);
}

void Display_Off()
{
	Send_MAX6950(0x400);						// disable display driver
	SPI0->C1 = 0x00;							// disable SPI system
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x80) | PORT_GPCLR_GPWD(0x100); 	// configure PA.7 for GPIO
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x01) | PORT_GPCLR_GPWD(0x100); 	// configure PB.0 for GPIO
	PTA->PCOR = 1 << CS;						// CS down
	PTB->PCOR = 1 << PWR;						// power down MAX6950	
}
