#include <MKL03Z4.h> 
#include "hardware.h"
#include "lis2dw12.h"

uint8_t ACC_status[8];
uint8_t ACC_data[8];

void LIS2DW12_setup()
{
	uint8_t ctrl1[] = {0x20, 0x40}; 		// low-power mode, 12-bit, 50 Hz
	uint8_t ctrl3[] = {0x22, 0x18};			// open-drain INT, active low
	uint8_t ctrl4[] = {0x23, 0x40};			// INT = single-tap
	uint8_t thres[] = {0x30, 0x01}; 		// tap recognition thresholds X/Y/Z
	uint8_t enabl[] = {0x32, 0x80};			// enable tap-X recognition
//	uint8_t sleep[] = {0x34, 0x40};			// sleep enable	
	uint8_t ctrl7[] = {0x3F, 0x20};			// enable interrupts	
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, ctrl1, 2);
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, ctrl3, 2);
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, ctrl4, 2);
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, thres, 2);
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, enabl, 2);
//	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, sleep, 2);
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, ctrl7, 2);
	LIS2DW12_getInt();	
}

void LIS2DW12_getInt()
{
	uint8_t all_int[] = {0x3B};				// all interrupts register
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, all_int, 1);
	I2CMasterReadBuf(LIS2DW12_SLAVE_ADDRESS, &ACC_status[7], 1);	
}

void LIS2DW12_getData()
{
	uint8_t status[] = {0x27};				// status register		
	I2CMasterWriteBuf(LIS2DW12_SLAVE_ADDRESS, status, 1);
	I2CMasterReadBuf(LIS2DW12_SLAVE_ADDRESS, ACC_data, 7);	
}
