#include <MKL03Z4.h> 
#include "hardware.h"
#include <core_cm0plus.h>

void SMC_setup(void)							// configure low-power run/stop modes
{
	SIM->CLKDIV1 = SIM_CLKDIV1_OUTDIV4(3);		// set 1 MHz bus clock 1:4 divider
	SMC->PMPROT = SMC_PMPROT_AVLP_MASK;						// allow VLPR, VLPW, VLPS modes
	SMC->PMCTRL = SMC_PMCTRL_RUNM(2) | SMC_PMCTRL_STOPM(2); // enter VLPS mode in STOP 
}

void PORTS_setup(void)							// configure I/O ports
{
	SIM->SCGC5 |= SIM_SCGC5_PORTA_MASK | SIM_SCGC5_PORTB_MASK;		// enable clock for I/O ports
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x80) | PORT_GPCLR_GPWD(0x100); 	// configure PA.7 for GPIO
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x20) | PORT_GPCLR_GPWD(0x103); 	// enable pull-up on PA.5 
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x18) | PORT_GPCLR_GPWD(0x300);  // I2C0 on PA[3:4]
	PORTA->PCR[6] = PORT_PCR_MUX(2);			// configure PA.6 for TPM0.0
	PTA->PDOR = 0;
	PTA->PDDR = 0xFF;							// output on PA 
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x07) | PORT_GPCLR_GPWD(0x100); 	// configure PB[0:2] for GPIO
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x3A) | PORT_GPCLR_GPWD(0x103); 	// enable pull-up on PB[1, 3:5]
	PTB->PDOR = 0;
	PTB->PDDR = 0x05;							// input on PB[1, 3:5]
	NVIC_ClearPendingIRQ(PORTB_IRQn);			// clear interrupts from PORTB				
	NVIC_EnableIRQ(PORTB_IRQn);					// enable PORTB interrupt in NVIC		
}

void RTC_setup(void)
{
	SIM->SCGC6 |= SIM_SCGC6_RTC_MASK;			// enable RTC access
	RTC_TSR = 0;								// reset TSR to clear pending IF (hardware bug)
}	

void LPTMR0_setup(void)							// Low-Power Timer configuration
{												//    for 1 second delay
	SIM->SCGC5 |= SIM_SCGC5_LPTMR_MASK;			// enable clock for LPTMR
	LPTMR0->CSR = 0;							// make sure that timer is disabled
	LPTMR0->CMR = 1000;							// 1000 msec delay
	LPTMR0->PSR = LPTMR_PSR_PBYP_MASK | LPTMR_PSR_PCS(1); // set LPO as clock source, no prescaler	
	NVIC_ClearPendingIRQ(LPTMR0_IRQn);			// enable SPI0 interrupt in NVIC
	NVIC_EnableIRQ(LPTMR0_IRQn);
}

void TPM0_setup(void)							// configure TPM0 channel0 for PWM
{
	SIM->SCGC6 |= SIM_SCGC6_TPM0_MASK;			// enable clock to TMP0
	SIM->SOPT2 |= SIM_SOPT2_TPMSRC(3);			// select MCGIRCLK clock
	TPM0->CONTROLS[0].CnSC = TPM_CnSC_MSB_MASK | TPM_CnSC_ELSB_MASK; // edge-aligned PWM mode
	TPM0->CONTROLS[0].CnV = 625;				// set 50% duty cycle
	TPM0->MOD = 1250;							// set tone 3.2 KHz
}

void I2C0_setup(void)
{
	SIM->SCGC4 |= SIM_SCGC4_I2C0_MASK;			// enable clock for I2C module
	I2C0->F = 0;								// div by 20 I2C clock rate
	NVIC_ClearPendingIRQ(I2C0_IRQn);			// enable I2C0 interrupt in NVIC
	NVIC_EnableIRQ(I2C0_IRQn);	
}

void SPI0_setup(void)							// SPI module configuration
{
	SIM->SCGC4 |= SIM_SCGC4_SPI0_MASK;			// enable clock for SPI0 module
	SPI0->BR = 0;								// set bus_freq/2 baud rate	
}

void delay(uint16_t d)
{
	NVIC_ClearPendingIRQ(LPTMR0_IRQn);			// clear pending LPTRM0 interrupt
	LPTMR0_CMR = d;								// set delay in ms 
	LPTMR0_CSR = LPTMR_CSR_TCF_MASK | LPTMR_CSR_TIE_MASK | LPTMR_CSR_TEN_MASK; // start timer	
	__WFI();
	LPTMR0_CSR = 0;								// stop timer disable interrupt
}
