	INCLUDE MKL03.inc
	
CS	EQU	5			; CS =  PA.5 (chip select)
	
	PRESERVE8
	THUMB				; use thumb instruction set
	AREA    |.text|, CODE, READONLY

;--------------------------------------------------------------------
Send_MAX6950	PROC			; send 16-bit word in R0 to MAX
	EXPORT	Send_MAX6950
	push	{R1-R2, LR}	

	ldr	R1, =GPIOA
	movs	R2, #(1<<CS)
	str	R2, [R1, #GPIO_PCOR]	; CS down
	
	ldr	R1, =SPI0
	rev16	R0, R0	
sm1	ldrb	R2, [R1, #SPI_S]	; read status
	lsrs	R2, #6			; wait for SPTEF bit set
	bcc	sm1
	strb	R0, [R1, #SPI_D]	; send data

	rev16	R0, R0	
sm2	ldrb	R2, [R1, #SPI_S]	; read status
	lsrs	R2, #6			; wait for SPTEF bit set
	bcc	sm2
	strb	R0, [R1, #SPI_D]	; send_data

sm3	ldrb	R0, [R1, #SPI_S]	; read status
	lsrs	R0, #8			; wait for SPRF bit set
	bcc	sm3
	ldrb	R2, [R1, #SPI_D]	; reset SPFR flag
	
sm4	ldrb	R0, [R1, #SPI_S]	; read status
	lsrs	R0, #8			; wait for SPRF bit set
	bcc	sm4
	ldrb	R2, [R1, #SPI_D]	; reset SPFR flag	
	
	ldr	R1, =GPIOA
	movs	R2, #(1<<CS)
	str	R2, [R1, #GPIO_PSOR]	; CS up
	pop	{R1-R2, PC}
	ENDP
	
;-------------------------------------------------------------------------------
I2CMasterWriteBuf	PROC		; R0=address, R1=buf, R2=len	
	EXPORT	I2CMasterWriteBuf
	push	{LR,R4,R7}
	adds	R4, R0, R0
	mov	R7, R1
	adds	R3, R2, #1	
	PUTW	SLEEPONEXIT, 0, SCB_SCR ; set sleep on exit
	PUTB	0xD0, I2C_C1, I2C0	; enable I2C module TX, and interrupt 
	PUTB	0xF0, I2C_C1		; generate START condition
	strb	R4, [R0, #I2C_D]	; send address	
	movs	R4, #0
	wfi				; enter sleep mode 	
	PUTB	0, I2C_C1		; I2C reset	
	pop	{PC,R4,R7}
	ENDP			

I2CMasterReadBuf	PROC		; R0=address, R1=buf, R2=len
	EXPORT	I2CMasterReadBuf
	push	{LR,R4,R7}
	adds	R3, R0, R0
	adds	R3, #1
	mov	R7, R1
	mov	R4, R2	
	PUTW	SLEEPONEXIT, 0, SCB_SCR ; set sleep on exit
	PUTB	0xD0, I2C_C1, I2C0	; enable I2C module TX, and interrupt 
	PUTB	0xF0, I2C_C1		; generate START condition
	strb	R3, [R0, #I2C_D]	; send address	
	movs	R3, #1
	wfi				; enter sleep mode	
      PUTB	0, I2C_C1		; I2C reset	
	pop	{PC,R4,R7}
	ENDP				

;--------------------------------------------------------------------
;	IMPORT	I2Cbuf
I2C0_IRQHandler	PROC
	EXPORT	I2C0_IRQHandler
	ldrb	R1, [R0, #I2C_FLT]
	lsrs	R1, #7			; STOP condition detected?
	bcs	I2C_STOP		; YES - exit
	ldrb	R2, [R0, #I2C_S]	; get status byte
	strb	R2, [R0, #I2C_S]	; clear I2C interrupt flags
	ldrb	R1, [R0, #I2C_C1]	; get command byte
	lsrs	R1, #5			; TX ot RX mode?
	bcc	I2C_RX
	
I2C_TX	
	subs	R3, #1			; last byte transmitted?
	beq	tx1			; YES - check for receive
	lsrs	R2, #1			; NO  - is ACK received?		
	bcs	tx3			; NO  - generate STOP	
	ldrb	R1, [R7]		; YES - get next byte
	strb	R1, [R0, #I2C_D]	; and send it over
	adds	R7, #1			; update data pointer	
	bx	LR

tx1	orrs	R4, R4			; receive bytes?
	beq	tx3			; NO - generate STOP
	movs	R1, #0xE0		; YES - switch to RX mode
	cmp	R4, #1			; receive only 1 byte?
	bne	tx2			; NO
	movs	R1, #0xE8		; YES - prepare to send NAK
tx2	strb	R1, [R0, #I2C_C1]	; switch to RX mode
	ldrb	R1, [R0, #I2C_D]	; read dummy byte to start RX
	bx	LR
tx3
	PUTB	0x60, I2C_FLT		; enable STOP interrupt
	PUTB	0xD0, I2C_C1		; generate STOP		
	bx	LR

I2C_RX	
	subs	R4, #1			; last byte read?
	bmi	rx3
	bne	rx1			; YES - exit
	PUTB	0x60, I2C_FLT		; enable STOP interrupt	
	PUTB	0xC0, I2C_C1		; generate STOP	
	b	rx2

rx1	cmp	R4, #1			; 2nd to last byte received?
	bne	rx2	
	PUTB	0xE8, I2C_C1		; YES - prepare to send NAK

rx2	ldrb	R1, [R0, #I2C_D]	; read received byte
	strb	R1, [R7]		; store it in buffer
	adds	R7, #1			; update buffer pointer
rx3	bx	LR	
	
I2C_STOP
	PUTB	0x40, I2C_FLT		; clear STOP flag
	PUTB	0x02, I2C_S
	PUTB	0x80, I2C_C1		; disable I2C0 interrupts
	ldr	R3, =SCB_SCR		; cancel sleep on exit 
	movs	R1, #0
	str	R1, [R3]
	bx	LR
	ENDP
		
	ALIGN	
	END	