; Peripheral base addresses
GPIO		EQU	0x4000F000  	; GPIO controller (aliased to 0x400F_F000)
Flash		EQU	0x40020000  	; Flash memory
TPM0		EQU	0x40038000 	; Timer/PWM (TPM) 0
TPM1		EQU	0x40039000 	; Timer/PWM (TPM) 1
ADC0		EQU	0x4003B000	; Analog-to-digital converter (ADC) 0
RTC		EQU	0x4003D000	; Real-time clock (RTC)	
LPTMR0		EQU	0x40040000 	; Low-power timer (LPTMR)
REGISTRY	EQU	0x40041000	; System register file	
SIML		EQU	0x40047000 	; SIM low-power logic
SIM		EQU	0x40048000 	; System integration module (SIM)
PORTA		EQU	0x40049000 	; Port A multiplexing control
PORTB		EQU	0x4004A000 	; Port B multiplexing control
LPUART0		EQU	0x40054000	; LPUART0		
MCG		EQU	0x40064000 	; Multi-purpose Clock Generator (MCG)
OSC		EQU	0x40065000 	; System oscillator (OSC)
I2C0		EQU	0x40066000 	; I2C 0
COMP		EQU	0x40073000 	; Analog comparator (CMP) / 6-bit DAC
VREF		EQU	0x40074000	; Voltage reference (VREF)
SPI0		EQU	0x40076000 	; SPI 0
LLWU		EQU	0x4007C000	; Low-leakage wakeup unit (LLWU)	
PMC		EQU	0x4007D000 	; Power management controller (PMC)
SMC		EQU	0x4007E000 	; System Mode controller (SMC)
RCM		EQU	0x4007F000 	; Reset Control Module (RCM)
GPIOA		EQU	0x400FF000	; GPIOA controller
GPIOB		EQU	0x400FF040	; GPIOB controller

;----------- RTC registers --------------------------------------------------------
RTC_TSR		EQU	0x00 		; RTC Time Seconds Register 0000h 33.3.1/501
RTC_TPR		EQU	0x04 		; RTC Time Prescaler Register
RTC_TAR		EQU	0x08 		; RTC Time Alarm Register
RTC_TCR		EQU	0x0C 		; RTC Time Compensation Register
RTC_CR		EQU	0x10 		; RTC Control Register
RTC_SR		EQU	0x14 		; RTC Status Register
RTC_LR		EQU	0x18 		; RTC Lock Register
RTC_IER		EQU	0x1C 		; RTC Interrupt Enable Register

;----------- LPTMR0 registers -----------------------------------------------------
LPTMR_CSR	EQU	0x00		; Low Power Timer Control Status Register
LPTMR_PSR	EQU	0x04		; Low Power Timer Prescale Register
LPTMR_CMR	EQU	0x08		; Low Power Timer Compare Register
LPTMR_CNR	EQU	0x0C		; Low Power Timer Counter Register

;----------- SIM registers --------------------------------------------------------
SIM_SOPT1	EQU	0x00		; System Options Register 1
SIM_SOPT2	EQU	0x04 		; System Options Register 2 
SIM_SOPT4	EQU	0x0C 		; System Options Register 4 
SIM_SOPT5	EQU	0x10 		; System Options Register 5 
SIM_SOPT7	EQU	0x18 		; System Options Register 7 
SIM_SCGC4	EQU	0x34		; System Clock Gating Control Register 4
SIM_SCGC5	EQU	0x38		; System Clock Gating Control Register 5
SIM_SCGC6	EQU	0x3C		; System Clock Gating Control Register 6
SIM_SCGC7	EQU	0x40 		; System Clock Gating Control Register 7 
SIM_CLKDIV1	EQU	0x44		; System Clock Divider Register 1
SIM_COPC	EQU	0x100		; COP Control Register
SIM_SRVCOP	EQU	0x104		; Service COP 
	
;----------- PORT registers -----------------------------------------------------
PORT_PCR0	EQU	0x00		; Pin Control Register n
PORT_GPCLR	EQU	0x80		; Global Pin Control Low Register
PORT_GPCHR	EQU	0x84		; Global Pin Control High Register
PORT_ISFR	EQU	0xA0 		; Interrupt Status Flag Register
	
;----------- MCG registers -----------------------------------------------------
MCG_C1		EQU	0x00		; MCG Control 1 Register
MCG_C2		EQU	0x01		; MCG Control 2 Register
MCG_S		EQU	0x06		; MCG Status Register
MCG_SC		EQU	0x08		; MCG Status and Control Register
MCG_MC		EQU	0x18		; MCG Miscellaneous Control Register
	
;----------- I2C registers -----------------------------------------------------
I2C_A1		EQU	0x00		; I2C Address Register 1
I2C_F		EQU	0x01		; I2C Frequency Divider register
I2C_C1		EQU	0x02		; I2C Control Register 1
I2C_S		EQU	0x03		; I2C Status register
I2C_D		EQU	0x04		; I2C Data I/O register
I2C_C2		EQU	0x05		; I2C Control Register 2
I2C_FLT		EQU	0x06		; I2C Programmable Input Glitch Filter register
I2C_RA		EQU	0x07		; I2C Range Address register
I2C_SMB		EQU	0x08		; I2C SMBus Control and Status register
I2C_A2		EQU	0x09		; I2C Address Register 2
I2C_SLTH	EQU	0x0A		; I2C SCL Low Timeout Register High
I2C_SLTL	EQU	0x0B		; I2C SCL Low Timeout Register Low 
I2C0_S2		EQU	0x0C		; I2C Status register 2
	
;----------- SPI registers -----------------------------------------------------
SPI_S		EQU	0x00 		; SPI Status Register
SPI_BR		EQU	0x01 		; SPI Baud Rate Register
SPI_C2		EQU	0x02 		; SPI Control Register 2 	
SPI_C1		EQU	0x03		; SPI Control Register 1 
SPI_M		EQU	0x04 		; SPI Match Register
SPI_D		EQU	0x06 		; SPI Data Register
	
;----------- SMC registers ------------------------------------------------------
SMC_PMPROT	EQU	0x00		; Power Mode Protection register
SMC_PMCTRL	EQU	0x01		; Power Mode Control register
SMC_STOPCTRL	EQU	0x02		; Stop Control Register
SMC_PMSTAT	EQU	0x03		; Power Mode Status register

;----------- GPIO registers -----------------------------------------------------
GPIO_PDOR	EQU	0x00		; Port Data Output Register
GPIO_PSOR	EQU	0x04		; Port Set Output Register
GPIO_PCOR	EQU	0x08		; Port Clear Output Register
GPIO_PTOR	EQU	0x0C		; Port Toggle Output Register
GPIO_PDIR	EQU	0x10		; Port Data Input Register
GPIO_PDDR	EQU	0x14		; Port Data Direction Register

;-------- ARM Core registers ----------------------------------------------------
NVIC_ISER	EQU	0xE000E100	; NVIC SETENA
NVIC_ICER	EQU	0xE000E180	; NVIC CLRENA
NVIC_ISPR	EQU	0xE000E200	; NVIC SETPEND
NVIC_ICPR	EQU	0xE000E280	; NVIC CLRPEND

SCB_SCR		EQU	0xE000ED10	; System Control Register
SLEEPDEEP	EQU	0x04		; bits in System Control Register
SLEEPONEXIT	EQU	0x02	

	MACRO				; store data in a given register
	PUTW	$wdata, $reg, $base
	IF	"$base" <> "" 
	ldr	R0, =$base
	ENDIF
	IF	$wdata <= 0xFF
	movs	R1, #$wdata
	ELSE
	ldr	R1, =$wdata
	ENDIF
	IF	$reg <= 0x1F
	str	R1, [R0, #$reg]
	ELSE
	movs	R2, #$reg
	str	R1, [R0, R2]
	ENDIF			
	MEND

	MACRO
	PUTB	$wdata, $reg, $base
	IF	"$base" <> "" 
	ldr	R0, =$base
	ENDIF
	movs	R1, #$wdata	
	IF	$reg <= 0x1F
	strb	R1, [R0, #$reg]
	ELSE
	movs	R2, #$reg
	strb	R1, [R0, R2]	
	ENDIF
	MEND

	MACRO				; AND a word with data in memory
	IOANDW	$wdata, $addr
	ldr	R0, =($addr + (1<<26))
	ldr	R1, =$wdata
	str	R1, [R0]
	MEND

	MACRO				; AND a halfword with data in memory
	IOANDH	$wdata, $addr
	ldr	R0, =($addr + (1<<26))
	ldr	R1, =$wdata
	strh	R1, [R0]
	MEND

	MACRO				; AND a byte with data in memory
	IOANDB	$wdata, $addr
	ldr	R0, =($addr + (1<<26))
	movs	R1, #$wdata
	strb	R1, [R0]
	MEND
	
	MACRO				; OR a word with data in memory
	IOORW	$wdata, $addr
	ldr	R0, =($addr + (1<<27))
	ldr	R1, =$wdata
	str	R1, [R0]
	MEND

	MACRO				; OR a halfword with data in memory
	IOORH	$wdata, $addr 
	ldr	R0, =($addr + (1<<27))
	ldr	R1, =$wdata
	strh	R1, [R0]
	MEND

	MACRO				; OR a byte with data in memory
	IOORB	$wdata, $addr
	ldr	R0, =($addr + (1<<27))
	movs	R1, #$wdata
	strb	R1, [R0]
	MEND	
	
	MACRO				; XOR a word with data in memory
	IOXORW	$wdata, $addr
	ldr	R0, =($addr + (3<<26))
	ldr	R1, =$wdata
	str	R1, [R0]
	MEND

	MACRO				; XOR a halfword with data in memory
	IOXORH	$wdata, $addr
	ldr	R0, =($addr + (3<<26))
	ldr	R1, =$wdata
	strh	R1, [R0]
	MEND

	MACRO				; XOR a byte with data in memory
	IOXORB	$wdata, $addr
	ldr	R0, =($addr + (3<<26))
	movs	R1, #$wdata
	strb	R1, [R0]
	MEND		
		
	END
	