;  -   ()
;    
; 19.11.2004  - 4 

.include "2313def.inc";  

.def sreg =r0;->    SREG

.def dataB0 =r1;->  
.def dataD0 =r16
.def dataB1 =r3;->  
.def dataD1 =r17
.def dataB2 =r5;->  
.def dataD2 =r18
.def dataB3 =r7;->  
.def dataD3 =r19

.def data =r20; ->  
.def temp =r21

.def indecod =r22;->    
.def oudecodB =r23;->      B
.def oudecodD =r24;->      D

.def count =r25 ;->    
.def count2 =r26;->    

.CSEG
.org	0
	rjmp START		;   

.org	INT0addr
	rjmp	Forward	;Oa   INT0 ()
.org	INT1addr
	rjmp	Back		;Oa   INT1 ()

Forward:
	sbic	PinD,3	;  PD3  0,   
	reti

	push	sreg		; SREG
	inc	count		;   1

	mov	data,count	;  
	andi	data,$0F	;   
	cpi	data,$0A	;   10
	brlo	EndInt	;   10,   


	andi	count,$F0	;  
	ldi	data,$10
	add	count,data	;   1
	cpi	count,$A0
	brlo	EndInt	;   100

	clr	count		;   
	inc	count2	;   1

	mov	data,count2
	andi	data,$0F	;   ()
	cpi	data,$0A	;  10
	brlo	EndInt	; 10

	andi	count2,$F0
	ldi	data,$10
	add	count2,data	;   1,   0
	cpi	count2,$A0
	brlo	EndInt	;   10,   

	clr	count		; 
	clr	count2
	rjmp	EndInt

Back:
	sbic	PinD,2	;  PD2  0,   
	reti
	push	sreg		; SREG
	dec	count		;   1

	mov	data,count
	andi	data,$0F
	cpi	data,$0A	;  10
	brlo	EndInt	;  10   


	andi	count,$F0
	ori	count,9	;  9

	cpi	count,$A0
	brlo	EndInt	;  100,   

	ldi	count,$99	;   99
	dec	count2	;   1

	mov	data,count2
	andi	data,$0F
	cpi	data,$0A	;  10
	brlo	EndInt	;  10   

	andi	count2,$F0
	ori	count2,9	;  9

	cpi	count2,$A0
	brlo	EndInt	;  10000,   

	ldi	count,$99	;  9999
	ldi	count2,$99
	
EndInt:
	rcall	LeDdecoding	; 
	pop	sreg        ;  SREG
	wdr			; . 
	reti
;*************************************************************************
;  
;*************************************************************************
START:
	ldi	temp,$0F
	out	WDTCR,temp	;   1,9 .

	ldi	temp,$DF
       out	SPL,temp	;  
       ldi	temp,0b01001100;  
	out	portD,temp	;    D
	ldi	temp,0b01110011
       out	DDRD,temp	;  PortD (1)-
       ldi	temp,0b11111100
       out	DDRB,temp	;   B  ,.1,2 - 
	out	PortB,temp	;    

	rcall	LongDelay	;   
	wdr			; . 

;**************************************************************************
;     EEPROM    
EEread:
	sbic	EECR,EEWE	;    EEPROM
	rjmp	EERead
	ldi	temp,0
	out	EEAR,temp	; 
	sbi	EECR,EERE	;  
	in	count,EEDR	;   EEPROM
EEread2:
	sbic	EECR,EEWE	;    EEPROM
	rjmp	EERead2
	ldi	temp,1
	out	EEAR,temp	; 
	sbi	EECR,EERE	;  
	in	count2,EEDR	;   EEPROM

	rcall	LeDdecoding	;

	ldi	temp,$C0
	out	GIMSK,temp	;  INT0-1 GIMSK
	ldi	temp,$F
	out	MCUCR,temp	;MCUCR   INT0-1  
	ldi	temp,$C0
	out	GIFR,temp	;   
	sei			; 

;  

MAIN:
	wdr			; . 
	ldi	temp,0b01001100
	out	PortD,temp	;  
	out	PortB,dataB3;   
	out	PortD,dataD3;   D -  

	rcall	Delay		;

	out	PortD,temp
	out	PortB,dataB2
	out	PortD,dataD2	; 

	rcall	Delay

	out	PortD,temp
	out	PortB,dataB1
	out	PortD,dataD1	; 

	rcall	Delay

	out	PortD,temp
	out	PortB,dataB0
	out	PortD,dataD0	; 

	rcall	Delay

ButtonRes:
	sbic	PinB,1	;-    ?
	rjmp	Dalee		;     Dalee
	ldi	temp,0b11101100; -   '-'   
	out	portB,temp
	ldi	temp,0b01101100
	out	portD,temp
	rcall	Delay
	ldi	temp,0b01011100
	out	portD,temp
	rcall	Delay
	ldi	temp,0b01001110
	out	portD,temp
	rcall	Delay
	ldi	temp,0b01001101
	out	portD,temp
	rcall	Delay
	wdr
	sbis	PinB,1	;-   ?
	rjmp	ButtonRes	;     ButtonRes

	clr	count		; c
	clr	count2
	rcall	LeDdecoding	;

Dalee:
	sbic	ACSR,ACO	;-   (  0)
	rjmp	MAIN		,   
	cli			;  
	ldi	temp,0b01001100
	out	PortD,temp
	ldi	temp,0b11111100  ;  
	out	PortB,temp
	wdr			; . 

EEWrite:		;-    EEPROM
	sbic	EECR,EEWE	;    EEPROM
	rjmp	EEWrite
	ldi	temp,0
	out	EEAR,temp	;   EEPROM
	out	EEDR,count	;  . 
	ldi	temp,4
	out	EECR,temp	;  EEMWE  1, EEWE  0
	sbi	EECR,EEWE	;  
EEWrite2:
	sbic	EECR,EEWE	;    
	rjmp	EEWrite2
	ldi	temp,1
	out	EEAR,temp
	out	EEDR,count2
	ldi	temp,4
	out	EECR,temp
	sbi	EECR,EEWE
	wdr			; . 
	
Cykl:	sbis	ACSR,ACO	;   U 
	rjmp	Cykl
	rcall	LongDelay	;  0,5 
	wdr			; . 
	sbis	ACSR,ACO	
	rjmp	Cykl
	rcall	LongDelay	;  0,5 
	wdr			; . 
	sbis	ACSR,ACO	
	rjmp	Cykl

;------ 1 .      
	ldi	r20,$C0	;  
	out	GIFR,r20
	sei			; 
	rjmp	MAIN		;  


;*********************  *******************************
;    7  
LeDdecoding:
	mov	indecod,count2
	swap	indecod
	rcall	Decod
	mov	dataB3,oudecodB	;
	mov	dataD3,oudecodD
	cpi	indecod,0
	breq	M100
	sbr	dataD3,0b000100000

M100:	mov	indecod,count2
	rcall	Decod
	mov	dataB2,oudecodB	;
	mov	dataD2,oudecodD
	cpi	count2,0
	breq	M10
	sbr	dataD2,0b000010000

M10:	mov	indecod,count
	swap	indecod
	rcall	Decod
	mov	dataB1,oudecodB	;
	mov	dataD1,oudecodD
	cpi	count2,0
	brne	N1
	cpi	indecod,0
	breq	M1
N1:	sbr	dataD1,0b000000010

M1:	mov	indecod,count
	rcall	Decod
	mov	dataB0,oudecodB	;
	mov	dataD0,oudecodD
	sbr	dataD0,0b000000001

	ret


;      .

Decod:
	andi	indecod,$F	;   . 
	cpi	indecod,0
	breq	S0
	cpi	indecod,1
	breq	S1
	cpi	indecod,2
	breq	S2
	cpi	indecod,3
	breq	S3
	cpi	indecod,4
	breq	S4
	cpi	indecod,5
	breq	S5
	cpi	indecod,6
	breq	S6
	cpi	indecod,7
	breq	S7
	cpi	indecod,8
	breq	S8
	cpi	indecod,9
	breq	S9
Blank:
	ldi	oudecodB,0b11111100;   ,    
	ldi	oudecodD,0b01001100
	ret

; 2  3     1, ..    
; 
;          
;       , -
;  S0  S9.
;		           abcdeg__  -   ( )
;		            f        -   ( D)
;		           76543210  -  
S0:	ldi	oudecodB,0b00010000; - 0
	ldi	oudecodD,0b00001100
	ret
S1:	ldi	oudecodB,0b10110100; - 1
	ldi	oudecodD,0b01001100
	ret
S2:	ldi	oudecodB,0b00101000; - 2
	ldi	oudecodD,0b00001100
	ret
S3:	ldi	oudecodB,0b00100000; - 3
	ldi	oudecodD,0b01001100
	ret
S4:	ldi	oudecodB,0b10000100; - 4
	ldi	oudecodD,0b01001100
	ret
S5:	ldi	oudecodB,0b01000000; - 5
	ldi	oudecodD,0b01001100
	ret
S6:	ldi	oudecodB,0b01000000; - 6
	ldi	oudecodD,0b00001100
	ret
S7:	ldi	oudecodB,0b00110100; - 7
	ldi	oudecodD,0b01001100
	ret
S8:	ldi	oudecodB,0b00000000; - 8
	ldi	oudecodD,0b00001100
	ret
S9:	ldi	oudecodB,0b00000000; - 9
	ldi	oudecodD,0b01001100
	ret

;    (0,5   2,5 )

LongDelay:	; 0,5 
	push	temp
	ldi	temp,$85
	out	TCNT1H,temp	;   1
	ldi	temp,$EE
	out	TCNT1L,temp	;   1
	rjmp	PUSK

Delay:		; 2,5 
	push	temp
	ldi	temp,$FF
	out	TCNT1H,temp	;   1
	ldi	temp,$64
	out	TCNT1L,temp	;   1

PUSK:		; 
	ldi	temp,3
	out	TCCR1B,temp	; -  1   

LooP:		;
	in	temp,TIFR
	sbrs	temp,7	;- ?
	rjmp	LooP
	ldi	temp,0
	out	TCCR1B,temp	;  
	ldi	temp,$80
	out	TIFR,temp	;   
	pop	temp
	ret